DROP PROCEDURE [hips].[StateCodeGet]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Philip Stalley-Gordon
-- Create date:	  13 Nov 2013	
-- Description:   Gets a list or specific record from the linkage of the State Code Table
-- =============================================
CREATE PROCEDURE [hips].[StateCodeGet] 
(
	@CodeSystemCode VARCHAR(20),
	@StateId INT = NULL
)
AS
BEGIN

	SELECT  st.StateId, st.Code, st.Description
	FROM    hips.StateCode sc
			JOIN hips.State st ON sc.StateId = st.StateId
			JOIN hips.CodeSystem cs ON sc.CodeSystemId = cs.CodeSystemId
			WHERE cs.Code = @CodeSystemCode
			AND (st.StateId = @StateId OR @StateId IS NULL)
	ORDER BY st.Description

END
GO

